
; ==============================================================================================
;
;  -------------------------------------------------------
;  TARGET COMPUTER
;  -------------------------------------------------------
;  
;  FOR IC SOCKET U33 ON THE IBM 5150 MOTHERBOARD.
;
;  --------------------------------------------------
;  WHAT DOES THE CODE DO ?
;  --------------------------------------------------
;  
;  In a loop, the code:
;  Step 1: Reads address 055AAh (21930d) (055A:000A in the CPU)
;  Step 2: Reads address 0AA55h (43605d) (0AA5:0005 in the CPU)
;  
;  ( On a 64KB-256KB type of 5150 motherboard, both addresses are in bank 0. )
;  
;  Reference diagram at https://minuszerodegrees.net/5150/motherboard/IBM%205150%20motherboard%20-%2064KB-256KB%20-%20Address%20bus%20to%20memory%20address%20bus.png
;  
;  The purpose is to test the [address bus to memory address bus multiplexer], and associated circuitry.
;  I.e. Is the multiplexor creating the expected ROW and COLUMN adddresses on the memory address bus?
;  
;  --------------------------------------------------
;  PREREQUISITE
;  --------------------------------------------------
;  
;  Given that the source address comes from the address bus, you need to verify operation of the address bus first.
;  
;  We do not want a RUBBISH IN = RUBBISH OUT situation.
;  
;  --------------------------------------------------
;  WHAT YOU SHOULD OBSERVE IF USING A LOGIC ANALYSER
;  --------------------------------------------------
;  
;  Using a logic analyser:
;  - When motherboard address 055AAh is read, the ROW address presented to RAM chips (all banks) is 55h, and the COLUMN adddress presented is AAh.
;  - When motherboard address 0AA55h is read, the ROW address presented to RAM chips (all banks) is AAh, and the COLUMN adddress presented is 55h.
;  
;  In TEST5076.ZIP is a logic analyser capture:
;  Line 1 = /RAS pin of any chip in bank 0. Bank 0 because the two motherboard addresses we use are in bank 0 of a 16KB-64KB motherboard, and therefore, bank 0 will be where the /RAS pulses are sent.
;  Line 2 = /CAS pin of any chip in bank 0. Bank 0 because the two motherboard addresses we use are in bank 0 of a 16KB-64KB motherboard, and therefore, bank 0 will be where the /CAS pulses are sent.
;  Line 3 = A group, being the memory address bus. I connected the 8 probes to the 8 address pins of a RAM chip in bank 0 (although other banks would have worked).
; 
; -------------------------------------------------------
; LIMITATIONS
; -------------------------------------------------------
; 
; Certain cases of motherboard failure will stop this code from running.
; 
; -------------------------------------------------------
; COMPILATION
; -------------------------------------------------------
; 
; COMPILE THIS CODE USING NASM 2.10 (OR LATER).
;
; ==============================================================================================

BITS 16

CPU 8086

ORG 0			; Offset 0 in ROM (i.e. address FE000 in IBM 5150 address space)

TIMES 0x1F00 DB 0	; Pad with zero to address 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)


; ----------------------------------------------------------------------------------------------
; CODE STARTS HERE, AT ADDRESS 1F00h in ROM (i.e. address FFF00 in IBM 5150 address space)
; ----------------------------------------------------------------------------------------------

	cli

LOOP:	mov	dx,055Ah
	mov	es,dx
	mov	al,byte es:[0Ah]	; Read address 055AAh (21930d) (055A:000A in the CPU)

	mov	dx,0AA5h
	mov	es,dx
	mov	al,byte es:[5]		; Read address 0AA55h (43605d) (0AA5:0005 in the CPU)

	jmp	LOOP



TIMES 0x1FF0-($-$$) DB 0	; Pad out to reset vector.

	jmp	0xFFF0:0000

TIMES 0x2000-($-$$) DB 0	; Pad out to end of ROM.





