#ifndef ANIMAP.H

#define ANIMAP.H

#include "stddefs.h"
#include "animicon.h"

class animactor;

class animapSquare : public animslave
{
  public:
  byte myIconNumber, myTerrainType;
  int refresh; //should we refresh this square??
  animactor * nextActor;
  animapSquare() : animslave() {thisFrame = NULL; nextActor = NULL; myIconNumber = myTerrainType = 0;};
  inline void display(int x, int y, word pageBase, int squareWidth);
  virtual void advance(void);
  void drawActors(int x, int y, word pageBase);
};

typedef char fileNameString[15];

class animap
{
  public:
  byte squareWidth;
  word width, height;
  word numIcons;
  int lastScreenX, lastScreenY; //last pixel at which plotting started
  int lastMapX, lastMapY; //last map square at which plotting started
  int lastDrawWidth, lastDrawHeight; //width and height of last draw
  animapSquare * * mapData;
  animicon * iconTable;
  fileNameString * iconNames;
  animap(int numicons, int squidth, int iwidth, int iheight);
  animap(char * filename, yakLib * myYakLib = NULL); //loads and constructs map!
  ~animap();
  void * isInSquare(int x, int y, byte identity);
  void draw(int centerx, int centery, int screenx, int screeny, int radx,int rady, word offset);
  void show(int centerx, int centery, int screenx, int screeny, int radx,int rady, word offset);
  void drawXY(int left, int top, int screenLeft, int screenTop, int width,int height, word offset);
  void showXY(int left, int top, int screenLeft, int screenTop, int width,int height, word offset);
  void smartRefresh(int deltaX, int deltaY, word offset);
  void advance(void);
  void loadIcon(int position, char * filename, yakLib * myYakLib = NULL);
  void save(char * filename);
  void load(char * filename);
  void setSquare(word x, word y, byte icon_number);
  void reset(void);
  void randomize(void);
};

#endif