/*-----------------------------------------------------------------------
;
; XFILEIO - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;-----------------------------------------------------------------------*/

#ifndef _XFILEIO_H_
#define _XFILEIO_H_

#define F_RDONLY  0
#define F_WRONLY  1
#define F_RDWR    2

#define SEEK_START 0
#define SEEK_CURR  1
#define SEEK_END   2

#define FILE_ERR -1

/* FUNCTIONS =========================================================== */

extern int f_open(              /* Open a file returning its handle */
	 char * filename,
	 char access);

extern int f_close(             /* Close a file  */
	 int handle);

extern int f_read(              /* Read a block of data from a file */
	 int handle,
	 char far * buffer,
	 int count);

extern int f_write(             /* Write a block of data to a file */
	 int handle,
	 char far * buffer,
	 int count);

extern long int f_seek(         /* Position the file pointer */
	 int handle,
	 long int position,
	 char method_code);

extern long int f_filelength(   /* Return the length of the file */
	 int handle);

#endif


