GAMEPORT       =      201h

               IDEAL
	       MODEL  large

               DATASEG
               PUBLIC _jstk1_x, _jstk1_y, _jstk2_x, _jstk2_y
               PUBLIC _jsense, _jrange

_jstk1_x       dw     0          ; joystick 1 x-axis
_jstk1_y       dw     0          ; joystick 1 y-axis
_jstk2_x       dw     0          ; joystick 2 x-axis
_jstk2_y       dw     0          ; joystick 2 y-axis
_jsense        dw     1          ; joystick sensitivity
_jrange        dw     300        ; joystick range
               CODESEG

               PUBLIC _read_jstk
PROC           _read_jstk
               mov    dx,GAMEPORT
               out    dx,al          ;start timer
               xor    ax,ax
               mov    [_jstk1_x],ax  ;initialize to zero
               mov    [_jstk1_y],ax  ;
               mov    [_jstk2_x],ax  ;
               mov    [_jstk2_y],ax  ;
               mov    cx,[_jrange]   ;# times to iterate rangeloop
rangeloop:
               mov    bx,[_jsense]
delay:
               in     al,dx
               dec    bx
               jnz    delay

               shr    al,1
               adc    [_jstk1_x],bx
               shr    al,1
               adc    [_jstk1_y],bx
               shr    al,1
               adc    [_jstk2_x],bx
               shr    al,1
               adc    [_jstk2_y],bx
               loop   rangeloop
               not    al
               and    ax,0fh          ;return the button status in ax
               ret
ENDP           _read_jstk

               END
